import express from 'express';
import {
  login,
  getProfile,
  getDashboardStats,
  getAllUsers,
  createUser,
  updateUser,
  deactivateUser,
  getAllPaymentItems,
  createPaymentItem,
  updatePaymentItem,
  deactivatePaymentItem
} from '../controllers/adminController.js';
import { authenticateToken, requireRole } from '../middleware/auth.js';
import {
  validateLogin,
  validateAdminUser,
  validateAdminUserUpdate,
  validatePaymentItem
} from '../middleware/validation.js';

const router = express.Router();

// Public routes
router.post('/login', validateLogin, login);

// Protected routes
router.use(authenticateToken); // All routes below require authentication

// Profile and dashboard
router.get('/profile', getProfile);
router.get('/dashboard', getDashboardStats);

// User management (programming role only)
router.get('/users', requireRole(['imtc']), getAllUsers);
router.post('/users', requireRole(['imtc']), validateAdminUser, createUser);
router.put('/users/:email', requireRole(['imtc']), validateAdminUserUpdate, updateUser);
router.delete('/users/:email', requireRole(['imtc']), deactivateUser);

// Payment items management (programming role only)
router.get('/payment-items', getAllPaymentItems);
router.post('/payment-items', requireRole(['imtc']), validatePaymentItem, createPaymentItem);
router.put('/payment-items/:id', requireRole(['imtc']), validatePaymentItem, updatePaymentItem);
router.delete('/payment-items/:id', requireRole(['imtc']), deactivatePaymentItem);

export default router;
