import express from 'express';
import {
  getPaymentItems,
  initiatePayment,
  handlePaymentCallback,
  getTransactionByRRR,
  requeryPayment,
  getAllTransactions
} from '../controllers/paymentController.js';
import { authenticateToken, requireRole, optionalAuth } from '../middleware/auth.js';
import { validatePayment } from '../middleware/validation.js';

const router = express.Router();

// Public routes
router.get('/items', getPaymentItems);
router.post('/initiate', validatePayment, initiatePayment);
router.post('/callback', handlePaymentCallback);
router.get('/transaction/:rrr', getTransactionByRRR);
router.post('/requery', requeryPayment);

// Admin routes
router.get('/transactions', authenticateToken, requireRole(['bursary', 'imtc']), getAllTransactions);

export default router;
