import express from 'express';
import { upload, uploadPassport, deletePassport } from '../controllers/uploadController.js';
import { authenticateToken } from '../middleware/auth.js';

const router = express.Router();

// Upload passport photo (protected route)
router.post('/passport', authenticateToken, (req, res, next) => {
  upload.single('passport')(req, res, (err) => {
    if (err) {
      console.error('Multer error:', err);
      if (err.code === 'LIMIT_FILE_SIZE') {
        return res.status(400).json({
          success: false,
          message: 'File too large. Maximum size is 50KB.'
        });
      }
      return res.status(400).json({
        success: false,
        message: err.message
      });
    }
    next();
  });
}, uploadPassport);

// Delete passport photo (protected route)
router.delete('/passport/:filename', authenticateToken, deletePassport);

export default router;
